% Author: Layla S. Mayboudi
% 2021-05-27
% This code creates the geometries used in the geometry table.
% They include a cube, ellipse, rectangle, trapezoid, and circle.
% The geometries are either created independently or as part of a PDE
% transient thermal model.

clear all; clc; clf; close all;

set(groot,'DefaultAxesColorOrder',[0 0 0],...
    'DefaultSurfaceEdgeColor',[0 0 0],...
    'DefaultLineLineWidth',1,...
    'DefaultAxesLineStyleOrder','-|--|:|-.|+|o|*|.|x|s|d|^|v|>|<|p|h');      %may be added to set the line style and color.
ax.FontSize = 20; ax.FontName = 'Cambria'; ax.FontSmoothing = 'on'; ax.FontWeight = 'normal'; %'bold'; 

  %'DefaultAxesLineStyleOrder','-|--|:|-.|+|o|*|.|x|s|d|^|v|>|<|p|h'      %may be added to set the line style and color.
  %set(gcf,'defaultSurfaceEdgeColor','b')

 g1 = decsg ([1 0 0 1]'); figure(1); pdegplot(g1); 
 ax = gca; grid on; grid minor; ax.FontSize = 20; xlabel('x'); ylabel('y'); 
 g2 = decsg([2 6 0 1 2 3 2 1 1 2 2 1 0 0]'); figure(2); pdegplot(g2); % polygon solid
 ax = gca; grid on; grid minor; ax.FontSize = 20; xlabel('x'); ylabel('y'); 
 g3 = decsg([3 4 0 0 1 1 0 1 1 0]'); figure(3); pdegplot(g3);
 ax = gca; grid on; grid minor; ax.FontSize = 20; xlabel('x'); ylabel('y'); 
 g4 = decsg([4 0 0 1 0.5 pi/4]'); figure(4); pdegplot(g4); % ellipse solid
 ax = gca; grid on; grid minor; ax.FontSize = 20; xlabel('x'); ylabel('y'); 

ModelT = createpde('thermal','transient');
geom1 = [3;4;0;5;5;0;0;0;3;3];
geom1 = [3;4;0;5;5;0;0;0;3;3];
geom2 = [3;4;0;5;5;0;3;3;5;5];
gd = [geom1 geom2];
sf = 'geom1+geom2';
ns = char('geom1','geom2');
ns = ns';
dl = decsg(gd,sf,ns);
geometryFromEdges(ModelT,dl);
figure(5);
pdegplot(ModelT,'EdgeLabels','on','FaceLabels','on');
xlim([0 5]); ylim([0 5]);
ax = gca; grid on; grid minor; ax.FontSize = 20; xlabel('x'); ylabel('y'); 

ModelT = createpde;
C1 = [1,0,0,0.5]';
T1 = [3,3,-1,1,0,0,0,2]';
R1 = [3,4,-0.25,0.25,0.25,-0.25,...
    0.75,0.75,1.25,1.25]';
C1 = [C1;zeros(length(R1)-length(C1),1)];
T1 = [T1;zeros(length(R1)-length(T1),1)];
gm = [T1,C1,R1];
sf = 'R1-T1-C1';
ns = char('R1','T1','C1');
ns = ns';
g = decsg(gm,sf,ns);
geometryFromEdges(ModelT,g);
pdegplot(ModelT);
ax = gca; grid on; grid minor;...
ax.FontSize = 20; xlabel('x'); ylabel('y'); 

[x,y,z] = meshgrid(-0.5:0.1:0.5);
x = x(:); y = y(:); z = z(:);
K = convhull(x,y,z);
nodes = [x';y';z'];
elements = K';

model = createpde();
geometryFromMesh(model,nodes,elements);
pdegplot(model,'FaceLabels','on','FaceAlpha',0.5)
ax = gca; grid on; grid minor;...
ax.FontSize = 20; xlabel('x'); ylabel('y'); zlabel('z'); 
